(function (global, factory) {
  if (typeof define === "function" && define.amd) {
    define([], factory);
  } else if (typeof exports !== "undefined") {
    factory();
  } else {
    var mod = {
      exports: {}
    };
    factory();
    global.wphooks = mod.exports;
  }
})(typeof globalThis !== "undefined" ? globalThis : typeof self !== "undefined" ? self : this, function () {
  "use strict";

  /* global _wpUtilSettings */
  window.wp = window.wp || {};
  (function () {
    // Hook management system
    var hooks = {
      actions: {},
      filters: {}
    };
    function addHook(hookType, hookName, callback, priority) {
      if (!hooks[hookType][hookName]) {
        hooks[hookType][hookName] = [];
      }
      hooks[hookType][hookName].push({
        callback: callback,
        priority: priority || 10
      });
      hooks[hookType][hookName].sort(function (a, b) {
        return a.priority - b.priority;
      });
    }
    function removeHook(hookType, hookName, callback) {
      if (!hooks[hookType][hookName]) {
        return;
      }
      hooks[hookType][hookName] = hooks[hookType][hookName].filter(function (hook) {
        return hook.callback !== callback;
      });
    }
    function runHooks(hookType, hookName, value, args) {
      if (!hooks[hookType][hookName]) {
        return value;
      }
      hooks[hookType][hookName].forEach(function (hook) {
        value = hook.callback.apply(null, [value].concat(args));
      });
      return value;
    }
    wp.hooks = {
      addAction: function addAction(hookName, namespace, callback, priority) {
        addHook('actions', hookName, callback, priority);
      },
      addFilter: function addFilter(hookName, namespace, callback, priority) {
        addHook('filters', hookName, callback, priority);
      },
      doAction: function doAction(hookName, value) {
        var args = Array.prototype.slice.call(arguments, 2);
        runHooks('actions', hookName, value, args);
      },
      applyFilters: function applyFilters(hookName, value) {
        var args = Array.prototype.slice.call(arguments, 2);
        return runHooks('filters', hookName, value, args);
      },
      removeAction: function removeAction(hookName, callback) {
        removeHook('actions', hookName, callback);
      },
      removeFilter: function removeFilter(hookName, callback) {
        removeHook('filters', hookName, callback);
      }
    };
  })();
});