<?php

/**
 * Settings
 *
 * PHP version 5
 *
 * @category  PHP
 * @package   PHP_Form_Builder
 * @author    Softdiscover <info@softdiscover.com>
 * @copyright 2013 Softdiscover
 * @license   http://www.php.net/license/3_01.txt  PHP License 3.01
 * @version   CVS: $Id: intranet.php, v2.00 2013-11-30 02:52:40 Softdiscover $
 * @link      https://php-form-builder.zigaform.com/
 */
if (!defined('BASEPATH')) {
	exit('No direct script access allowed');
}

/**
 * Estimator intranet class
 *
 * @category  PHP
 * @package   PHP_Form_Builder
 * @author    Softdiscover <info@softdiscover.com>
 * @copyright 2013 Softdiscover
 * @license   http://www.php.net/license/3_01.txt  PHP License 3.01
 * @version   Release: 1.00
 * @link      https://php-form-builder.zigaform.com/
 */
class license extends BackendController
{
	/**
	 * max number of forms in order show by pagination
	 *
	 * @var int
	 */

	const VERSION = '0.1';

	/**
	 * name of form estimator table
	 *
	 * @var string
	 */
	protected $modules;
	public $CI;
	/**
	 * Settings::__construct()
	 *
	 * @return
	 */
	public function __construct()
	{
		parent::__construct();
		$this->load->language_alt(model_settings::$db_config['language']);
		$this->template->set('controller', $this);
		$this->load->model('model_settings');
		$this->CI = &get_instance();
		$this->load->helper('url');
		$this->load->library('session');
		$this->load->helper('file');
		$this->load->helper('form');
		$this->load->library('curl');

	}

	public function update_option(){
		// Get the purchase code from the AJAX request
		$purchase_code = $this->input->post('pcode', TRUE);
		
		$status= false;
		if(!empty($purchase_code)){
			$option = ['is_valid' => 1, 'code' => $purchase_code];
			update_option('zgfm_wpfb_code', $option);
			$status= true;
		}
		
		$json = ['success' => $status];
		header('Content-Type: application/json');
		echo json_encode($json);
		die();
	}
	
	public function validatepurchasecode()
	{

		// Get the purchase code from the AJAX request
		$purchase_code = $this->input->post('pcode', TRUE);
		$item = $this->input->post('item', TRUE);
	
		// Verify the purchase code using the API endpoint
		$api_url = "https://license-hub-zgfm.softdiscover.com/verify/code/$purchase_code/item/$item";
		$response = null;
		$use_fallback = false;
		$error_message = '';
	
		// Attempt to use cURL first
		if (function_exists('curl_init')) {
			$ch = curl_init($api_url);
			curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
			curl_setopt($ch, CURLOPT_TIMEOUT, 20); // Increase timeout
			curl_setopt($ch, CURLOPT_CONNECTTIMEOUT, 10);
			
			$response = curl_exec($ch);
			$http_code = curl_getinfo($ch, CURLINFO_HTTP_CODE);
	
			if ($response === false || $http_code !== 200) {
				$error_message = curl_error($ch) ?: "HTTP Status: $http_code";
				$use_fallback = true;
			}
	
			curl_close($ch);
		} else {
			$use_fallback = true;
		}
	
		// Use file_get_contents as a fallback if cURL fails or response code is not 200
		if ($use_fallback) {
			$context = stream_context_create(['http' => ['method' => 'GET', 'timeout' => 20]]);
			$response = @file_get_contents($api_url, false, $context);
	
			if ($response === false) {
				$error_message = error_get_last()['message'] ?? 'Unable to connect to server';
				echo json_encode(['success' => false, 'message' => "Something went wrong: $error_message"]);
				return;
			}
		}
	
		// Parse the response
		$data = json_decode($response, true);
		$json = [];
	
		if ($data && isset($data['success']) && $data['success'] === true) {
			$option = ['is_valid' => 1, 'code' => $purchase_code];
	
			// Save
			update_option('zgfm_wpfb_code', $option);
			$json = ['success' => true];
		} else {
			$error_message = $data['message'] ?? 'Invalid purchase code';
			$json = ['success' => false, 'message' => $error_message];
		}
		 
		 
		
	
// Set the content type to JSON
		header('Content-Type: application/json');
		echo json_encode($json);
		die();
	}
	
}
